<!doctype html>
<html lang='en'>
<head>
	<meta charset='UTF-8'>
	<meta name="msapplication-config" content="none"/>
	@section('meta')
		@if(isset($meta))
			@include('meta::html')
		@else
			<title>{{ Config::get('sculpt.site-name') }}</title>
		@endif
	@show
	@section('head')
		@section('stylesheet')
			<link href='/css/screen.css?v={{ config('foundation.stylesheet-version') }}' media='screen, projection' rel='stylesheet' type='text/css' />
		@show
        <link type='text/plain' rel='author' href='/humans.txt' />
        <link rel='shortcut icon' href='/favicon{{ env('APP_ENV') !== 'live' ? '-' . env('APP_ENV') : '' }}.ico' />
		@section('head-after-style')
			<!--[if lte IE 8]>
			<script src='/vendor/selectivizr.js'></script>
			<script src='/vendor/respond.min.js'></script>
			<![endif]-->
			<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
            @if (Config::get('foundation.jquery'))
                <script src='//code.jquery.com/jquery-2.1.3.min.js'></script>
				<script type='text/javascript'>
					window.csrf_token = '{{ csrf_token() }}';
					$(function () {
						$.ajaxSetup({
							headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' }
						});
					});
				</script>
            @endif
		@show
        @section('analytics')
            @if(Config::has('foundation.codes.analytics') && !Config::get('app.debug'))
            <script>
                (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
                    (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
                        m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
                })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
                ga('create', '{{ Config::get('foundation.codes.analytics') }}', 'auto');
                ga('send', 'pageview');
            </script>
            @endif
        @show
	@show
</head>
<body class='{{ $body_class }}'>
	@include('foundation::maintenance-mode-message')

	@yield('body')

	@yield('body-end')
</body>
</html>
