<?php namespace Concore\Foundation\Handlers;

use Exception;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Illuminate\Foundation\Exceptions\Handler;

class ExceptionHandler extends Handler {

    protected function renderHttpException(HttpException $e)
    {
        $status = $e->getStatusCode();

        // Look in Foundation for error view files first

        if (view()->exists("foundation::errors.{$status}"))
        {
            return response()->view("foundation::errors.{$status}", ['body_class' => 'error error-' . $status], $status);
        }
        else if(view()->exists("errors.{$status}"))
        {
            return response()->view("errors.{$status}", [], $status);
        }
        else
        {
            return (new SymfonyDisplayer(config('app.debug')))->createResponse($e);
        }
    }

}