<?php

namespace Concore\Foundation\Image;

use Closure;

class ImageManager extends \Intervention\Image\ImageManager
{
    /**
     * Create new cached image and run callback
     * (requires additional package intervention/imagecache)
     *
     * @param Closure $callback
     * @param integer $lifetime
     * @param boolean $returnObj
     *
     * @return Image
     */
    public function cache(Closure $callback, $lifetime = null, $returnObj = false)
    {
        if (class_exists('Concore\\Foundation\\Image\\ImageCache')) {
            // create imagecache
            $imagecache = new \Concore\Foundation\Image\ImageCache($this);

            // run callback
            if (is_callable($callback)) {
                $callback($imagecache);
            }

            return $imagecache->get($lifetime, $returnObj);
        }

        throw new \Intervention\Image\Exception\MissingDependencyException(
            "Please install package intervention/imagecache before running this function."
        );
    }
}
