<?php namespace Concore\Foundation\Models\Traits;

trait HasKeyTrait {

	public static function find($key_or_id, $columns = array()) {
		if(is_numeric($key_or_id)) {
			return parent::find($key_or_id);
		} else {
			return static::where('key','=',$key_or_id)->first();
		}
	}

	public function setKeyAttribute($value) {
		$this->attributes['key'] = str_slug($value);
	}

	public function setNameAttribute($value) {
		$this->attributes['name'] = $value;
		$this->setKeyAttribute($value);
	}

}