<?php namespace Concore\Foundation\Providers\Traits;

trait ExplicitViewLoaderTrait {
	
	/**
	 * Register a view file namespace.
	 * Adding ! to the namespace makes sure the actual vendor view is loaded, not the published version.
	 * E.g namespace!::path instead of just namespace::path
	 *
	 * @param  string  $path
	 * @param  string  $namespace
	 * @return void
	 */
	protected function loadViewsFrom($path, $namespace)
	{
		if (is_dir($appPath = $this->app->basePath().'/resources/views/vendor/'.$namespace))
		{
			$this->app['view']->addNamespace($namespace, $appPath);
		}

		$this->app['view']->addNamespace($namespace, $path);
		$this->app['view']->addNamespace($namespace.'!', $path);
	}

}