<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMetasTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('metas',function(Blueprint $table) {
			$table->increments('id');
			$table->morphs('metaable');
			$table->string('title')->nullable()->default(null);
			$table->text('description')->nullable()->default(null);
			$table->string('publisher')->nullable()->default(null);
			$table->string('author')->nullable()->default(null);
			$table->boolean('no_index')->default(false);
			$table->boolean('no_follow')->default(false);
			$table->string('rss')->nullable()->default(null);
			$table->string('og_locale')->nullable()->default(null);
			$table->string('og_type')->nullable()->default(null);
			$table->string('og_title')->nullable()->default(null);
			$table->text('og_description')->nullable()->default(null);
			$table->string('og_url')->nullable()->default(null);
			$table->string('og_site_name')->nullable()->default(null);
			$table->string('og_image')->nullable()->default(null);
			$table->string('fb_publisher')->nullable()->default(null);
			$table->string('fb_app_id')->nullable()->default(null);
			$table->string('twitter_card')->nullable()->default(null);
			$table->string('twitter_domain')->nullable()->default(null);
			$table->string('twitter_image')->nullable()->default(null);
			$table->string('twitter_site')->nullable()->default(null);
			$table->string('twitter_creator')->nullable()->default(null);
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('metas');
	}

}
