<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddThumbnailIdToMetas extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('metas',function(Blueprint $table) {
			$table->integer('thumbnail_id')->unsigned()->nullable()->after('description');
			$table->foreign('thumbnail_id')->references('id')->on('media')->onDelete('cascade');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('metas',function(Blueprint $table) {
			$table->dropForeign('metas_thumbnail_id_foreign');
			$table->dropColumn('thumbnail_id');
		});
	}

}
