<meta charset='utf-8'>
<meta http-equiv='content-type' content='text/html; charset=UTF-8' />
<meta http-equiv='X-UA-Compatible' content='IE=edge'>
<meta name='viewport' content='width=device-width, initial-scale=1'>

{{-- Basic meta --}}

<title>{{ $meta->title }}</title>
<meta name='description' content='{{ $meta->description }}' />

{{-- Extra meta --}}

@if($meta->publisher)
    <link rel='publisher' href='{{ $meta->publisher }}'/>
@endif
@if($meta->author)
    <link rel='author' href='{{ $meta->author }}'/>
@endif
<link rel='canonical' href='{{ $meta->canonical_url }}'/>
@if($meta->short_url)
    <link rel='shortlink' href='{{ $meta->short_url }}' />
@endif
@if($meta->robots)
    <meta name='robots' content='{{ $meta->robots }}' />
@endif
<meta name='generator' content='Laravel {{ $app::VERSION }}' />

@if($meta->rss)
    <link rel='alternate' type='application/rss+xml' href='{{ $meta->rss }}' />
@endif

{{-- OpenGraph/Facebook --}}

@if($meta->og_title)
    <meta property='og:title' content='{{ $meta->og_title }}'/>
@endif
@if($meta->og_description)
    <meta property='og:description' content='{{ $meta->og_description }}'/>
@endif
@if($meta->og_url)
    <meta property='og:url' content='{{ $meta->og_url }}'/>
@endif
@if($meta->og_image)
	<meta property='og:image' content='{{ $meta->og_image }}'/>
@endif
@if($meta->og_locale)
    <meta property='og:locale' content='{{ $meta->og_locale }}'/>
@endif
@if($meta->og_type)
    <meta property='og:type' content='{{ $meta->og_type }}'/>
@endif
@if($meta->og_site_name)
	<meta property='og:site_name' content='{{ $meta->og_site_name }}'/>
@endif
@if($meta->fb_publisher)
    <meta property='article:publisher' content='{{ $meta->fb_publisher }}'/>
@endif
@if($meta->fb_app_id)
    <meta property='fb:app_id' content='{{ $meta->fb_app_id }}'/>
@endif

{{-- Twitter --}}

@if($meta->twitter_card)
    <meta name='twitter:card' content='{{ $meta->twitter_card }}'/>
@endif
@if($meta->twitter_domain)
	<meta name='twitter:domain' content='{{ $meta->twitter_domain }}'/>
@endif
@if($meta->twitter_image)
	<meta name='twitter:image:src' content='{{ $meta->twitter_image }}'/>
@endif
@if($meta->twitter_site)
    <meta name='twitter:site' content='{{ $meta->twitter_site }}'/>
@endif
@if($meta->twitter_creator)
    <meta name='twitter:creator' content='{{ $meta->twitter_creator }}'/>
@endif