<?php namespace Concore\Meta\Models;

use Concore\Meta\Models\Interfaces\MetaInterface;
use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\IdentifiableTrait;

class BaseMeta extends \Illuminate\Database\Eloquent\Model implements IdentifiableInterface, MetaInterface
{
    use IdentifiableTrait;

    protected $table = 'metas';

    public $guarded = ['id'];

    public $timestamps = false;

    public function getModel() {
        if(isset($this->attributes['metaable_type']) && !empty($this->attributes['metaable_type'])) {
            $class = '\\' . $this->attributes['metaable_type'];
            return $class::find($this->attributes['metaable_id']);
        } else {
            return null;
        }
    }

    public function __toString() {
        return view('meta::html',['meta' => $this,'app' => app()])->__toString();
    }

    public function getDefault() {
        $default = $this::where('metaable_type','=','')->first();
        // If there's no default meta, just create a brand new (empty) meta object so all values will be null
        return $default ?: new self;
    }

    public function thumbnail() {
        return $this->belongsTo(app('Concore\Foundation\Models\Media'));
    }

    public function getAttribute($field) {
        // If meta model has the field, give that
        if(isset($this->attributes[$field]) && $this->attributes[$field]) {
            return $this->attributes[$field];
        }
        return null;
    }
}