<?php namespace Concore\Meta\Models;

use Request, Config;

class Meta extends BaseMeta {

    public function getAttribute($field) {
        if($value = parent::getAttribute($field)) {
            return $value;
        }
        $model = $this->getModel();
        // If the parent model has a function that defines this, use that
        if($model && method_exists($model,'getMeta' . studly_case($field))) {
            return $model->{'getMeta' . studly_case($field)}();
        }
        // If it's something we can work out without an associated model (i.e. when using default meta), do it
        switch ($field) {
            case 'canonical_url':
            case 'short_url':
            case 'og_url':
                return Request::url();
                break;
            case 'og_locale':
                return Config::get('meta.default.og_locale');
                break;
            case 'og_type':
                return Config::get('meta.default.og_type');
                break;
            case 'twitter_card':
                return Config::get('meta.default.twitter_card');
                break;
            case 'og_site_name':
            case 'twitter_domain':
                return Config::get('meta.default.site_name');
                break;
            case 'og_title':
                return $this->title;
                break;
            case 'og_description':
                return $this->description;
                break;
            case 'fb_publisher':
            case 'author':
                return $this->publisher;
                break;
            case 'thumbnail':
                return $this->thumbnail()->first();
                break;
            case 'twitter_image':
                return $this->thumbnail ? $this->thumbnail->getUrl() : null;
                break;
            case 'robots':
                $value = [];
                if ($this->no_index) $value[] = 'no index';
                if ($this->no_follow) $value[] = 'no follow';
                $value = implode(', ', $value);
                return $value;
                break;
        }
        // Otherwise, if we have a model, use that to work it out
        if ($model) {
            $default = $this->getDefault();
            // If it's the title use a combination of the model name and default title
            if ($field == 'title') {
                if (strlen($model->name) > 200) {
                    return $model->name;
                } else {
                    return $model->name . ' | ' . $default->title;
                }
            }
            // If it's anything else use the default
            if (isset($default->attributes[$field]) && $default->attributes[$field]) {
                return $default->attributes[$field];
            }
        }
        return null;
    }

}