<?php namespace Concore\Meta\Providers;

use Illuminate\Support\ServiceProvider;
use Concore\Foundation\Providers\Traits\ExplicitViewLoaderTrait;

class MetaServiceProvider extends ServiceProvider {

	use ExplicitViewLoaderTrait;

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
		//
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
		$this->loadViewsFrom(__DIR__.'/../../resources/views/', 'meta');

		// Publishes

		$this->publishes([
	        __DIR__.'/../../resources/views/' => base_path('resources/views/vendor/meta'),
	    ], 'views');
	    $this->publishes([
		    __DIR__.'/../../migrations/' => $this->app->databasePath() . '/migrations'
		], 'migrations');

        $this->app->bind('Concore\Meta\Models\Interfaces\MetaInterface','Concore\Meta\Models\Meta');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

}
