<?php

use Illuminate\Database\Migrations\Migration;

class CreateNotesTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('notes', function($table)
		{
			$table->increments('id');
            $table->integer('note_type_id')->unsigned()->nullable();
            $table->foreign('note_type_id')->references('id')->on('note_types')->onDelete('set null');
            $table->text('content');
            $table->text('data')->nullable();
            $table->date('date')->nullable();
            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users');
            $table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('notes');
	}

}
