<?php namespace Concore\Notes\Models;

use AuditLog;
use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Illuminate\Database\Eloquent\Model;

class Note extends Model implements IdentifiableInterface {
	
	use IdentifiableTrait;

	protected $guarded = ['id','created_at','updated_at'];

    protected $dates = ['date'];

    protected $casts = ['data' => 'array'];

    public $relation_methods = ['note_type'];

    public function note_type() {
        return $this->belongsTo(app('Concore\Notes\Models\NoteType'));
    }

    public function media() {
        return $this->morphedByMany(app('Concore\Foundation\Models\Media'),'noteable');
    }

    public function created_by() {
        return $this->belongsTo(app('Concore\Foundation\Models\User'));
    }

    public function setDateAttribute($value) {
        if(!empty($value)) {
            $this->attributes['date'] = $value;
        }
    }

    public function setNoteTypeIdAttribute($value) {
        $this->attributes['note_type_id'] = !empty($value) ? $value : null;
    }

}