<?php namespace Concore\Notes\Providers;
use Illuminate\Support\ServiceProvider;

class NotesServiceProvider extends ServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register() {
		$this->bindings();
		$this->middleware();
        $this->config();
        $this->routes();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{

		$this->composers();

		$this->loadViewsFrom(__DIR__.'/../../resources/views', 'notes');
    
        //$this->loadTranslationsFrom(__DIR__.'/../../resources/lang', 'package-name');

		// Publishes 
		
		//$this->publishes([
	    //    __DIR__.'/../../public' => base_path('public/vendor/sculpt'),
	    //], 'assets');
		$this->publishes([
	        __DIR__.'/../../resources/views' => base_path('resources/views/vendor/notes'),
	    ], 'views');
		$this->publishes([
	        __DIR__.'/../../migrations' => base_path('database/migrations'),
	    ], 'migrations');

	}

	protected function bindings()
	{
        $this->app->bind('sculpt-model.note','Concore\Notes\Models\Note');
        $this->app->tag('sculpt-model.note','sculpt-models');
        $this->app->bind('sculpt-model.note-type','Concore\Notes\Models\NoteType');
        $this->app->tag('sculpt-model.note-type','sculpt-models');
	}

	protected function middleware()
	{
    
        //$this->app->make('router')->middleware('name', 'Concore\Package\Http\Middleware\Middleware');
    }

    protected function config()
    {
        //$this->mergeConfigFrom(
        //    __DIR__.'/../../config/package-name.php', 'package-name'
        //);
    }

	protected function routes()
	{
		//include __DIR__.'/../Http/routes.php';
	}

	protected function composers() 
	{
		//View::composer('package::view', 'Concore\Package\Http\ViewComposers\Composer');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

}