<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class RemoveSizeAddMinMaxFloorAndLand extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('properties', function(Blueprint $table)
		{
			$table->dropColumn('size');
			$table->integer('floor_min')->after('body');
			$table->integer('floor_max')->after('body');
			$table->decimal('land_min', 10, 3)->after('body');
			$table->decimal('land_max', 10, 3)->after('body');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('properties', function(Blueprint $table)
		{
			$table->integer('size');
			$table->dropColumn('floor_min');
			$table->dropColumn('floor_max');
			$table->dropColumn('land_min');
			$table->dropColumn('land_max');
		});
	}

}
