@extends($layout)

@section('content')
	<section id='property-search-results'{{ !count($properties) ? " class='no-favourites'" : "" }}>
		@if(count($properties))
			<h1>{{ trans('properties::favourites.header') }}</h1>
			@if(Route::has('contact'))
				<a href='{{ route("submission","contact") }}' class='enquire-button'>Enquire about these properties now</a>
			@endif
			@section('results')
				<div class="results">
					<a href='{{ route("properties") }}' class='add-new-favourites-button'>Add more properties</a>
					<a href='{{ route("properties.remove-all-favourites") }}' class='remove-all-favourites-button'>Remove all properties</a>
					<h3>{{ count($properties) . (count($properties) > 1 ? ' properties' : ' property') }}</h3>
					@include('properties::partials.list')
				</div>
			@show
		@else
			<h1>{{ trans('properties::favourites.header-empty') }}</h1>
			<p>{!! link_to_route("properties",trans('properties::favourites.add-many')) !!} and email us about them all at once.
		@endif
	</section>
@stop