@extends($layout)

@section('content')
	<section id='property-search-results' class='search-results'>
		<div class='property-filters'>
			<h1>Property Search</h1>
			@include('properties::partials.filter-form')
		</div>
		@if(count($properties))
			@section('results')
				<div class="results">
					@if($input)
						<h3>{{ $count . ($count > 1 ? ' properties' : ' property') }} found</h3>
					@else
						<h3>Latest properties</h3>
					@endif
					{!! $paginator->render() !!}
					@include('properties::partials.list')
					{!! $paginator->render() !!}
				</div>
			@show
		@else
			<h3>No properties found</h3>
			<p>Please adjust your search options.</p>
		@endif
	</section>
@stop

@section('body-end')
@parent
@include('properties::partials.favourite-ajax')
@stop