<script>
$(document).ready(function() {
	$('.favourite-button').click(function(e) {
		e.preventDefault();
		var $this = $(this);
		var $count = $('#favourites-box .count');
		$this.addClass('loading');
		count = parseInt($count.html());
		$.ajax({
			method: "GET",
			url: $this.attr('href')
		}).done(function(response) {
			if ($this.hasClass('favourite')) {
				count--;
				removeFavourite($this);
			}
			else {
				count++;
				$this.addClass('favourite');
				$this.attr('href','{{ URL::route('property.remove-favourite', null) }}/' + $this.data('id'));
				$this.html("<span>{{ trans('properties::favourites.remove-one') }}</span>");
				if ($('body').hasClass('search')) {
					$this.parents('.details').addClass('favourite');
				}
			}
			$count.html(count);
			if (count > 0) {
				if(!$('#favourites-box').is(':visible')) {
					showFavouritesBox();
				}
			}
			else {
				hideFavouritesBox();
			}
			$this.removeClass('loading');
		});
	});
	$('#favourites-box a.clear').click(function(e) {
		e.preventDefault();
		$.ajax({
			method: "GET",
			url: $(this).attr('href')
		}).done(function(response) {
			$('.favourite-button').each(function() {
				removeFavourite($(this));
			});
			$('#favourites-box .count').html(0);
			hideFavouritesBox();
		});
	});
});
function showFavouritesBox() {
	$('#favourites-box').css({
		opacity: 0,
		bottom: '-40px'
	}).show().animate({
		opacity: 1,
		bottom: 0
	},300);
}
function hideFavouritesBox() {
	$('#favourites-box').animate({
		opacity: 0,
		bottom: '-40px'
	},300,function() {
		$(this).hide();
	});
}
function removeFavourite($button) {
	$button.removeClass('favourite');
	$button.attr('href','{{ URL::route('property.add-favourite', null) }}/' + $button.data('id'));
	$button.html("<span>{{ trans('properties::favourites.add-one') }}</span>");
	if ($('body').hasClass('search')) {
		$button.parents('.details').removeClass('favourite');
	}
}
</script>