{!! Form::open(['route' => 'properties', 'id' => 'property-filter-form', 'method' => 'get']) !!}
	<dl class='form-inputs'>
		<div class='checkboxes available-for'>
			<dt>For</dt>
			<dd>
				{{-- Form::select('opportunity_types[]', [false=>''] + $opportunity_types, isset($input['opportunity_types']) ? $input['opportunity_types'] : '', ['multiple', 'class'=>'chosen-select']) --}}
				@foreach($opportunity_types as $id => $opportunity_type)
				<label>
					{!! Form::checkbox("opportunity_types[$opportunity_type]", $id, isset($input['opportunity_types'][$opportunity_type]) ? $input['opportunity_types'][$opportunity_type] : '') !!}
					{{ $opportunity_type }}
				</label>
				@endforeach
			</dd>
		</div>
		<label class='full-width property-type'>
			<dt>Property Type</dt>
			<dd>{!! Form::select('property_types[]', [false=>''] + $property_types, isset($input['property_types']) ? $input['property_types'] : '', ['multiple', 'class'=>'chosen-select']) !!}</dd>
		</label>
		<label class='full-width size'>
			<dt>Size (sq ft)</dt>
			<dd>
				{!! Form::select('min_size', [0=>'No min',500=>500,1000=>'1,000',2000=>'2,000',5000=>'5,000',10000=>'10,000',15000=>'15,000',25000=>'25,000',50000=>'50,000',100000=>'100,000',150000=>'150,000',300000=>'300,000',500000=>'500,000',700000=>'700,000',900000=>'900,000',1100000=>'1,100,000',1300000=>'1,300,000',1500000=>'1,500,000'], isset($input['min_size']) ? $input['min_size'] : 0) !!}
				{!! Form::select('max_size', [0=>'No max',500=>500,1000=>'1,000',2000=>'2,000',5000=>'5,000',10000=>'10,000',15000=>'15,000',25000=>'25,000',50000=>'50,000',100000=>'100,000',150000=>'150,000',300000=>'300,000',500000=>'500,000',700000=>'700,000',900000=>'900,000',1100000=>'1,100,000',1300000=>'1,300,000',1500000=>'1,500,000'], isset($input['max_size']) ? $input['max_size'] : 900000) !!}
			</dd>
		</label>
		<label class='location'>
			<dt>Location</dt>
			<dd>{!! Form::text('location', isset($input['location']) ? $input['location'] : '',['placeholder' => '(City / Postcode)']) !!}</dd>
		</label>
		@if(Request::route() && Request::route()->getName() !== 'home')
			<label class='distance'>
				<dt>Distance (miles)</dt>
				<dd>{!! Form::select('distance', [5=>5,10=>10,15=>15,20=>20,30=>30,40=>40,50=>50,100=>100], isset($input['distance']) ? $input['distance'] : '50', ['class'=>'chosen-select']) !!}</dd>
			</label>
			<script>
			function checkDistance() {
				if($input.val() != '') {
					$label.fadeIn(200);
				} else {
					$label.fadeOut(200);
				}
			}
			var $input = $('input[name=location]');
			var $label = $('label.distance').hide();
			checkDistance();
			$input.keyup(checkDistance);
			</script>
			<label class='keywords'>
				<dt>Keywords</dt>
				<dd>{!! Form::text('term', isset($input['term']) ? $input['term'] : '') !!}</dd>
			</label>
		@endif
		<div class='submit'>
			{!! Form::submit('Find Properties') !!}
		</div>
	</dl>
{!! Form::close() !!}

@section('head-after-style')
<link href='/vendor/chosen/chosen.min.css' media='screen, projection' rel='stylesheet' type='text/css' />
<link href='/vendor/jquery.nouislider.min.css' media='screen, projection' rel='stylesheet' type='text/css' />
@parent
@stop

@section('body-end')
@parent
<script>
$('#property-filter-form :submit').click(function(e) {
	e.preventDefault();
    if(typeof ga !== 'undefined') {
        ga('send', 'event', 'Event', 'PropertySearch', 'Searched');
    }
	var inputCount = $('#property-filter-form :input').length;
	i = 1;
	$('#property-filter-form :input').each(function() {
		var $this = $(this);
		if (!$this.val()) {
			$this.prop('disabled', true);
		}
		if (i == inputCount) {
			$('#property-filter-form').submit();
		}
		else {
			i++;
		}
	});
});
</script>
<script src='/vendor/chosen/chosen.jquery.min.js'></script>
<script src='/vendor/jquery.nouislider.all.min.js'></script>
<script>
function thousandsCommas(text) {
	return text.replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,");
}
$(document).ready(function() {
	$(".chosen-select").chosen({disable_search_threshold: 100});
	var $min_value = $('label.size select:first-child'),
	    $max_value = $('label.size select:last-child'),
	    $dd = $('label.size dd');
	$sliderMinValue = $('<input />').attr('type','text').attr('name',$min_value.attr('name')).val($min_value.val()).appendTo($dd);
	$sliderMaxValue = $('<input />').attr('type','text').attr('name',$max_value.attr('name')).val($max_value.val()).appendTo($dd);
	$('label.size select').remove();
	$slider = $('<div />').noUiSlider({
		start: [ $sliderMinValue.val(), $sliderMaxValue.val() ],
		behaviour: 'drag-tap',
		connect: true,
		range: {
			'min': [0, 500],
			'20%': [1000, 1000],
			'30%': [2000, 3000],
			'40%': [5000, 5000],
			'50%': [15000, 10000],
			'55%': [25000, 25000],
			'60%': [50000, 50000],
			'70%': [150000, 150000],
			'80%': [300000, 200000],
			'max': [1500000]
		},
		step: 1000,
		format: wNumb({
			thousand: ',',
			decimals: 0
		})
	});
	$slider.Link('lower').to($sliderMinValue)
	       .Link('upper').to($sliderMaxValue)
	       .insertAfter($sliderMinValue);
});
</script>
@stop