@extends($layout)

@section('content')
	<section class='banner small'>
		@section('property-banner')
			<div class='banner-inner'>
				<h1>{{ $property->name }}</h1>
				{!! $property->intro !!}
			</div>
		@show
	</section>
	<section class='property-main'>
		<a href='{{ route("properties",$filters) }}' class='back-button'>Back to results</a>
		@section('property-main')
			<img class='banner-img' src='http://lorempixel.com/500/300/city/{{ ($property->id % 9) + 1}}' alt="{{ $property->name }}" />
			<div class='body'>
				{!! $property->body !!}
                @if($property->isUnderOffer())
                    <strong class="under-offer">Property currently under offer</strong>
                @endif
				@include('properties::partials.specs')
			</div>
		@show
	</section>
@stop

@section('body-end')
@parent
@include('properties::partials.favourite-ajax')
@stop