<?php namespace Concore\Properties\Http\ViewComposers;

use Illuminate\Contracts\View\View;
use  Concore\Properties\Services\PropertyService;

class FavouritesBoxComposer {

    private $property_service;

    public function __construct(PropertyService $property_service) {
        $this->property_service = $property_service;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $property_count = $this->property_service->countFavourites();
        $view->with(compact('property_count'));
    }

}