<?php namespace Concore\Properties\Http\ViewComposers;

use Concore\Properties\Services\PropertyService;
use Illuminate\Contracts\View\View;

class PropertiesShowComposer {

    public function __construct(PropertyService $property_service) {
        $this->property_service = $property_service;
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $view->with([
            'filters' => $this->property_service->getFiltersFromSession()
        ]);
    }

}