<?php

/*
|--------------------------------------------------------------------------
| Package Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for a package.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::group(['namespace' => 'Concore\Properties\Http\Controllers'],function() {
	Route::get('/search/properties', ['as' => 'properties','uses' => 'PropertyController@index']);
	Route::get('/properties/' . Config::get('properties.url.plural'),['as' => 'properties.favourites','uses' => 'PropertyController@viewFavourites']);
	Route::get('/properties/' . Config::get('properties.url.add-one') . '/{id}',['as' => 'property.add-favourite','uses' => 'PropertyController@addToFavourites']);
	Route::get('/properties/' . Config::get('properties.url.remove-one') . '/{id}',['as' => 'property.remove-favourite','uses' => 'PropertyController@removeFromFavourites']);
	Route::get('/properties/' . Config::get('properties.url.remove-all'),['as' => 'properties.remove-all-favourites','uses' => 'PropertyController@removeAllFavourites']);
	Route::get('/properties/{key}',['as' => 'property','uses' => 'PropertyController@show'])->where('key','[a-z0-9\-]+');
});