<?php namespace Concore\Properties\Models;

use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Addresses\Models\Traits\HasAddressesTrait;

class Property extends \Illuminate\Database\Eloquent\Model {

	use IdentifiableTrait,
		HasAddressesTrait;

	public $is_favourite = false;

	protected $fillable = ['name','key','intro','body','land_max','land_min','floor_max','floor_min','status'];

	public function opportunity_types() {
		return $this->belongsToMany(app('Concore\Properties\Models\OpportunityType'));
	}

	public function property_types() {
		return $this->belongsToMany(app('Concore\Properties\Models\PropertyType'));
	}

    public function isUnderOffer() {
        return $this->status == 'Under Offer';
    }

}
