<?php namespace Concore\Properties\Providers;

use View;
use Illuminate\Support\ServiceProvider;
use Concore\Foundation\Providers\Traits\ExplicitViewLoaderTrait;

class PropertiesServiceProvider extends ServiceProvider {

	use ExplicitViewLoaderTrait;

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register()
	{
		$this->routes();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
		$this->composers();

		$this->loadViewsFrom(__DIR__.'/../../resources/views/', 'properties');
        
        $this->loadTranslationsFrom(__DIR__.'/../../resources/lang/', 'properties');

		// Publishes 
		
		$this->publishes([
	        __DIR__.'/../../resources/views/' => base_path('resources/views/vendor/properties'),
	    ], 'views');
	    $this->publishes([
		    __DIR__.'/../../migrations/' => $this->app->databasePath() . '/migrations'
		], 'migrations');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

	private function composers() 
	{
		View::composer('properties::partials.filter-form', 'Concore\Properties\Http\ViewComposers\FilterFormComposer');
		View::composer('properties::partials.favourites-box', 'Concore\Properties\Http\ViewComposers\FavouritesBoxComposer');
		View::composer('properties::partials.contact-option', 'Concore\Properties\Http\ViewComposers\ContactOptionComposer');
		View::composer('properties::show', 'Concore\Properties\Http\ViewComposers\PropertiesShowComposer');
	}

	protected function routes()
	{
		include __DIR__.'/../Http/routes.php';
	}

}
