<?php

use Illuminate\Database\Migrations\Migration;

class CreateRemindersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('reminders', function($table)
		{
			$table->increments('id');
            $table->string('type');
            $table->index('type');
            $table->integer('remindee_user_id')->unsigned();
            $table->foreign('remindee_user_id')->references('id')->on('users')->onDelete('cascade');
            $table->string('entity_type')->nullable();
            $table->integer('entity_id')->unsigned()->nullable();
            $table->enum('recurring_schedule',['hourly','daily','weekly','monthly','yearly'])->nullable();
            $table->dateTime('date_time');
            $table->text('notes')->nullable();
            $table->boolean('complete')->default(0);
            $table->timestamps();
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('reminders');
	}

}
