<?php

use Illuminate\Database\Migrations\Migration;

class AddCreatorToReminders extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('reminders', function($table) {
			$table->integer('creator_user_id')->nullable()->unsigned()->after('remindee_user_id');
			$table->foreign('creator_user_id')->references('id')->on('users')->onDelete('set null');
		});
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('reminders', function($table) {
			$table->dropColumn('creator_user_id');
		});
	}

}
