<?php namespace Concore\Reminders\Models;

use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Illuminate\Database\Eloquent\Model;

class Reminder extends Model implements IdentifiableInterface {

    use IdentifiableTrait;

    protected $guarded = ['id','created_at','updated_at'];

    public $relation_methods = ['user'];

    public $dates = ['date_time'];

    public $form_exclude_fields = ['entity_type','type'];

    public function user() {
        return $this->belongsTo(app('Concore\Foundation\Models\User'),'remindee_user_id');
    }

    public function getNameAttribute() {
        return 'Reminder: ' . $this->title;
    }

}