<?php namespace Concore\Reminders\Providers;

use Illuminate\Support\ServiceProvider;

class RemindersServiceProvider extends ServiceProvider {

	/**
	 * Indicates if loading of the provider is deferred.
	 *
	 * @var bool
	 */
	protected $defer = false;

	/**
	 * Register the service provider.
	 *
	 * @return void
	 */
	public function register() {
		$this->bindings();
	}

	/**
	 * Load utility functions, custom exceptions, view composers, form macros, custom validators.
	 * Register facades, service providers and aliases.
	 *
	 * @return void
	 */
	public function boot()
	{
		// Publishes
		$this->publishes([
	        __DIR__.'/../../migrations' => base_path('database/migrations'),
	    ], 'migrations');
        $this->loadViewsFrom(__DIR__.'/../../resources/views', 'reminders');
	}

	protected function bindings()
	{
        $this->app->bind('reminders','Concore\Reminders\Services\RemindersService');
        $this->app->bind('sculpt-model.reminder','Concore\Reminders\Models\Reminder');
        $this->app->tag('sculpt-model.reminder','sculpt-models');
        $this->app->bind('sculpt-controller.reminder-controller','Concore\Reminders\Http\Controllers\Sculpt\ReminderController');
	}

	/**
	 * Get the services provided by the provider.
	 *
	 * @return array
	 */
	public function provides()
	{
		return array();
	}

}