<?php namespace Concore\Reminders\Services;

use Concore\Reminders\Models\Reminder;

class RemindersService
{

    protected $reminder;

    public function __construct(Reminder $reminder)
    {
        $this->reminder = $reminder;
    }

    public function put($remindee, $type, $date_time, $entity = null, $reminding_schedule = null, $recurring_schedule = null, $notes = null) {
        $this->reminder->create([
            'remindee_user_id' => $remindee->id,
            'type' => $type,
            'entity_type' => $entity ? get_class($entity) : null,
            'entity_id' => $entity ? $entity->id : null,
            'date_time' => $date_time,
            'recurring_schedule' => $recurring_schedule,
            'notes' => $notes
        ]);
    }

    public function forRemindee($remindee, $before = null, $after = null) {
        $query = $this->reminder->where('remindee_user_id', $remindee->id);
        if (!is_null($before)) {
            $query->where('date_time', '<=', $before);
        }
        if (!is_null($after)) {
            $query->where('date_time', '>=', $after);
        }
        $query->whereComplete(false);
        return $query->get();
    }

    public function forEntity($entity, $before = null, $after = null) {
        $query = $this->reminder->where('entity_type', get_class($entity));
        $query->where('entity_id', $entity->id);
        if (!is_null($before)) {
            $query->where('date_time', '<=', $before);
        }
        if (!is_null($after)) {
            $query->where('date_time', '>=', $after);
        }
        $query->whereComplete(false);
        return $query->get();
    }

    public function markComplete($reminder) {
        if (!is_object($reminder)) {
            $reminder = $this->reminder->whereId($reminder)->first();
        }
        $reminder->complete = true;
        $reminder->save();
    }

}