<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddMoreTypeOptionsToTimeslotsTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('timeslots',function(Blueprint $table) {
            DB::statement("ALTER TABLE timeslots MODIFY COLUMN type ENUM(
              'Admin',
              'Letter Writing',
              'Telephone Call(s)',
              'Email(s)',
              'Travel',
              'Form Filling',
              'Research/information gathering',
              'Listening/reassurance',
              'Signposting',
              'Referrals',
              'Support/supervision'
            )");
            $table->string('type_other')->nullable()->after('type');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
        Schema::table('timeslots',function(Blueprint $table) {
            DB::statement("ALTER TABLE timeslots MODIFY COLUMN type ENUM('admin','phone','other')");
            $table->dropColumn('type_other');
        });
	}

}
