<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeCancerChampionTypeToLocalNational extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::table('cancer_champions',function(Blueprint $table) {
			$table->boolean('local')->nullable()->after('type');
			$table->boolean('national')->nullable()->after('type');
			$table->dropColumn('type');
        });
	}

	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::table('cancer_champions',function(Blueprint $table) {
			$table->enum('type',['Local','National'])->after('local');
			$table->dropColumn('local');
			$table->dropColumn('national');
		});
	}

}
