@extends('sculpt::auto.partials.forms.relations.to-many.inline',['in_tab' => false, 'show_in_panels' => false])

@section('timeslots-relation-title')
    @if($record->id && $record->hasEmptyTimeslots())
        <div class="alert alert-warning">
            <h5><i class="fa fa-fw fa-exclamation-triangle"></i> Warning</h5>
            <p>
                This activity was entered using an old version of SAM. Because of this, some or all timeslots for this activity do not have durations associated with them.
            </p>
            <p>
                This activity cannot be saved again until durations are added to all of the below timeslots.
            </p>
        </div>
    @endif
    <p>
        This activity involved...
        <span data-toggle="popover" data-trigger="hover" title="What is this?" data-content="<p>Add individual timeslots for each component of the activity. For example:</p>
        <ul>
            <li>If the activity lasted 30 minutes and involved 15 minutes of telephone calls and 15 minutes of admin, enter two timeslots, one for telephone calls and one for admin.</li>
            <li>If the activity lasted 15 minutes and all you did was telephone calls, enter a telephone call timeslot for 15 minutes.</li>
        </ul>" class="text-muted">
            <i class="fa fa-fw fa-info-circle"></i>
        </span>
    </p>
    @if($errors && $errors->has('timeslots'))
        <p class="alert alert-danger">Please choose at least one timeslot</p>
    @endif
@stop

@section('timeslots-after-forms')
    <p><strong>Total activity duration:</strong> <span id="total-timeslot-duration">{{ $record->duration ?: 0 }} mins</span></p>
@stop

@section('body-end')
    @parent
    <script>
        // Hide 'New Timeslot' button and just show a new empty form when populating previous one.
        // Get rid of empty forms when page is submitted.
        var $button = $('#new-timeslot-button');
        var $duration = $('#total-timeslot-duration');
        $button.trigger('click').hide();
        $('.timeslots').on('change','.timeslot select',function() {
            var both_filled_in = $(this).parent().parent().find('select').filter(function() {
                return $(this).children('option:selected').val() === '';
            }).length == 0;
            var any_empty_selects_already = $('.timeslot .type select').filter(function() {
                return $(this).children('option:selected').val() === '';
            }).length > 0;
            if(both_filled_in && !any_empty_selects_already) {
                $button.trigger('click');
            }
        });
        function checkTotalDuration() {
            var total_duration  = 0;
            $('.timeslots select[name*=duration]').each(function() {
                if($(this).val() !== '') {
                    total_duration += parseInt($(this).val());
                }
            });
            $duration.text(total_duration + ' mins');
        }
        $('.timeslots').on('change','.timeslot .duration select',function() { checkTotalDuration(); });
    </script>
@stop