<h1>Adding a New Activity</h1>

<div class="no-break">
    <h4>Step 1</h4>
    <p>Let's add a new activity on behalf of advocate <em>Sally Smith</em> for her case <em>Adam Brown</em>.</p>
    <p>In order to add a new activity, click <strong><i class="fa fa-plus"></i> New activity</strong> either from the dashboard by first clicking the arrow next to <strong>Activities</strong> in the main navigation.</p>
</div>

<div class="no-break">
    <h4>Step 2</h4>
    <p>We're now presented with the New Activity screen. This screen is split up into different sections:</p>
</div>

<div class="no-break">
    <h5>Who and When</h5>
    <p>This is where we describe who was involved in the activity, which case it was for (if any) and when it occured.</p>
</div>

<ul>
    <li>
        <p><strong>Service user case</strong></p>
        <p>If the activity was associated with a particular case, choose that case here (remember, we can type in this box to filter results). We'll choose <em>Adam Brown</em>.</p>
    </li>
    <li>
        <p><strong>Undertaken by</strong></p>
        <p>Who actually conducted the activity? If the activity is being logged on behalf of another user, enter their name here. Otherwise, enter yours. We enter <em>Sally Smith</em> here.</p>
    </li>
    <li>
        <p><strong>Date of activity</strong></p>
        <p>Enter when the activity occured.</p>
    </li>
    <li>
        <p><strong>People present</strong></p>
        <p>Here we should enter <em>everyone that was present</em> at the activity, including the service user and advocate (if this applies).</p>
        <p>If we have chosen a service user case and who undertook the activity, their names will be placed here automatically. If these people were not present, remove them from this list by pressing the <strong><i class="fa fa-times"></i></strong> icon on their name.</p>
        <p>We can enter other advocates, coordinators or local administrators that were present here, and also choose 'Other' to manually specify other people (e.g. a GP, friend, family member, etc).</p>
        <p class="alert alert-info">
            Entering people into this box will cause this activity to show up on their record under the <strong>Activities</strong> tab.
        </p>
    </li>
</ul>

<div class="no-break">
    <h5>Describe this activity</h5>
    <ul>
        <li>
            <p><strong>Nature of activity</strong></p>
            <p>Choose a nature of activity from the list. Try to choose an existing option, but if none apply we can choose 'Other' and specify our own. We'll choose 'Arranging services'.</p>
            <p class="alert alert-warning">
                <strong>Note:</strong> the natures shown in this list will be different depending on whether the activity has been assigned to a particular case or not.
            </p>
        </li>
        <li>
            <p><strong>Duration</strong> and <strong>This activity involved...</strong></p>
            <p>Specifying how long an activity took is done by specifying what specifically the activity involved and how long each thing took.</p>
            <p>Choose what the activity involved (e.g. telephone calls, emails, etc) and how long for each. More dropdowns will appear as we enter information - we don't need to use all of these, we should leave the last set blank.</p>
            <p class="alert alert-info">
                In our case, the activity involved telephone calls, email and signposting for about 15 minutes each. So we first choose Telephone calls from the first dropdown, then 15 minutes from the next. A second set of dropdowns will then appear for us to choose emails and 15 minutes, then a third set will appear to choose signposting and 15 minutes. You'll notice that the total duration will update to be 45 minutes.
            </p>
            <p class="alert alert-warning">
                <strong>Note:</strong> the options under 'This activity involved...' will be different depending on whether the activity has been assigned to a particular case or not.
            </p>
        </li>
        <li>
            <p><strong>Outcome</strong></p>
            <p>Enter the outcome of the activity.</p>
            <p class="alert alert-info">
                An excerpt of this outcome is shown when viewing tables of multiple activities under the <strong><i class="fa fa-eye"></i> Preview</strong> hover button.
            </p>
        </li>
    </ul>
</div>

<div class="no-break">
    <h5>Other Info</h5>
    <p>All the fields in this tab are optional, and simply provide more information about the activity for other users.</p>
</div>

<div class="no-break">
    <h5>Next Activity</h5>
    <p>The fields in this tab are optional too, see {!! link_to("$docs/activities/next",'Next Activity') !!} for more information on this tab.</p>
</div>

<div class="no-break">
    <h4>Step 3</h4>
    <p>We can now click <strong><i class="fa fa-floppy-o"></i> Add activity</strong> in order to save the activity in the system.</p>
    <p class="alert alert-info">
        This activity will now show up on the <strong>Activities</strong> tabs of: the user who undertook the activity, the case to which the activity is associated and anyone else involved. See {!! link_to("$docs/finding-information#_activities_for_case",'Find all activities for case') !!} or {!! link_to("$docs/finding-information#_activities_for_team_member",'Find all activities for team member') !!} for more info.
    </p>
</div>
