<?php $currently_active = $record->active_periods()->active()->first() ?: null; ?>

<div class="panel {{ $currently_active ? 'panel-success' : 'panel-warning' }}">
    <div class="panel-heading">
        @if($currently_active)
            <h3 class="panel-title"><i class="fa fa-fw fa-folder-open-o"></i> Open Case</h3>
        @else
            <h3 class="panel-title"><i class="fa fa-fw fa-folder-o"></i> Closed Case</h3>
        @endif
    </div>
    <div class="panel-body" style="padding-bottom:0;">
        @if($record->id)
            @if(Auth::user()->can('do:change-case-service-user'))
                @include(Sculpt::getView('partials.forms.relation'),['relation'=>'service_user'])
                <p style="margin-bottom:15px;">
                    <a href="{{ route('sculpt.show',['service-users',$record->service_user_id]) }}">Service user details <i class="fa fa-angle-right"></i></a>
                </p>
            @else
                <div class="form-group">
                    <label class="control-label">Service user:</label>
                    <a href="{{ route('sculpt.show',['service-users',$record->service_user_id]) }}">{{ $record->service_user->name }}</a>
                    <input type="hidden" name="service-user-case[service_user_id]" value="{{ $record->service_user_id }}" />
                </div>
            @endif
            <div class="form-group">
                <label class="control-label">Status:</label>
                @if($currently_active)
                    Open since {{ $currently_active->start->format('jS F Y') }}
                    @if(Auth::user()->can('do:close-case'))
                        <a href="{{ route('active-periods.end',$currently_active->id) }}"><i class="fa fa-fw fa-folder-o"></i> Close case</a>
                    @endif
                @elseif(!$record->active_periods()->inactive()->count())
                    Never been opened
                    @if(Auth::user()->can('do:open-case'))
                        <a href="{{ route('active-periods.start',[get_class($record), $record->id, $service_user_case_role_id]) }}"><i class="fa fa-fw fa-folder-open-o"></i> Open case</a>
                    @endif
                @else
                    Closed since {{ $record->active_periods()->orderBy('end','desc')->first()->end->format('jS F Y') }}
                    @if(Auth::user()->can('do:open-case'))
                        <a href="{{ route('active-periods.start',[get_class($record), $record->id, $service_user_case_role_id]) }}"><i class="fa fa-fw fa-folder-open-o"></i> Reopen case</a>
                    @endif
                @endif
            </div>
        @else
            @include(Sculpt::getView('partials.forms.relation'),['relation'=>'service_user'])
        @endif
        @if(Auth::user()->can('do:change-case-advocates'))
            @include(Sculpt::getView('partials.forms.relation'),['relation'=>'advocates'])
            @include(Sculpt::getView('partials.forms.field'),['field'=>'no_advocate_needed'])
        @endif
        @if(Auth::user()->can('see:identifying-information'))
            @include(Sculpt::getView('partials.forms.field'),['field'=>'brief_reason_for_referral'])
        @endif
    </div>

    @if($record->everActive())
        <table class="table">
            <thead>
                <tr>
                    <th>Opened</th>
                    <th>Opened by</th>
                    <th>Closed</th>
                    <th>Closed by</th>
                    <th width="150">Reason</th>
                    <th>Duration</th>
                </tr>
            </thead>
            @if($record->active_periods()->inactive()->count())
                @foreach($record->active_periods()->inactive()->get() as $active_period)
                    <tr>
                        <td>{{ $active_period->start->format('jS F Y') }}</td>
                        @if($active_period->activated_by)
                            <td>{{ $active_period->activated_by->name }}</td>
                        @else
                            <td>
                                <span class="text-muted">Not available</span>
                                <span data-toggle="popover" data-trigger="hover" title="Outcome" data-content="This role was activated using an old version of SAM where this information was not stored." class="text-muted">
                                    <i class="fa fa-fw fa-info-circle"></i>
                                </span>
                            </td>
                        @endif
                        <td>{{ $active_period->end->format('jS F Y') }}</td>
                        @if($active_period->deactivated_by)
                            <td>{{ $active_period->deactivated_by->name }}</td>
                        @else
                            <td>
                                <span class="text-muted">Not available</span>
                                <span data-toggle="popover" data-trigger="hover" title="Outcome" data-content="This role was activated using an old version of SAM where this information was not stored." class="text-muted">
                                    <i class="fa fa-fw fa-info-circle"></i>
                                </span>
                            </td>
                        @endif
                        <td>{{ $active_period->reason ? $active_period->reason->name : '' }}</td>
                        <td>{{ $active_period->length }} days</td>
                    </tr>
                @endforeach
            @endif
            @if($currently_active)
                <tr>
                    <td>{{ $currently_active->start->format('jS F Y') }}</td>
                    @if($activated_by = $record->active_periods()->active()->first()->activated_by)
                        <td>{{ $activated_by->name }}</td>
                    @else
                        <td>
                            <span class="text-muted">Not available</span>
                                <span data-toggle="popover" data-trigger="hover" title="Outcome" data-content="This role was activated using an old version of SAM where this information was not stored." class="text-muted">
                                    <i class="fa fa-fw fa-info-circle"></i>
                                </span>
                        </td>
                    @endif
                    <td>
                        @if(Auth::user()->can('do:close-case'))
                            <a href="{{ route('active-periods.end',$currently_active->id) }}">Close case now</a>
                        @endif
                    </td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
            @endif
        </table>
    @endif
</div>