<?php

use Concore\Addresses\Models\Address;
use Concore\Personnel\Models\ActivePeriod;
use Concore\Personnel\Models\Contact;
use Concore\Personnel\Models\ContactEntity;
use Concore\Personnel\Models\Independent;
use Concore\Personnel\Models\Organisation;
use Concore\Foundation\Models\User;
use Concore\Personnel\Models\Employee;
use Concore\Personnel\Models\Person;
use Concore\Personnel\Models\Reminder;
use Concore\Sam\Models\Advocate;
use Concore\Sam\Models\ServiceUser;
use Concore\Sam\Models\ServiceUserCase;
use Concore\Sam\Models\Task;
use Concore\Sculpt\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

class SamDemoDatabaseSeeder extends Seeder {

    /**
     * @var Organisation
     */
    private $organisation;
    /**
     * @var User
     */
    private $user;
    /**
     * @var Person
     */
    private $person;
    /**
     * @var Employee
     */
    private $employee;
    /**
     * @var Advocate
     */
    private $advocate;
    /**
     * @var ActivePeriod
     */
    private $active_period;
    /**
     * @var ServiceUser
     */
    private $service_user;
    /**
     * @var ServiceUserCase
     */
    private $service_user_case;
    /**
     * @var ContactEntity
     */
    private $contact_entity;
    /**
     * @var Contact
     */
    private $contact;
    /**
     * @var Task
     */
    private $task;
    /**
     * @var Independent
     */
    private $independent;
    /**
     * @var Role
     */
    private $role;
    /**
     * @var SamDatabaseSeeder
     */
    private $sam_seeder;
    /**
     * @var Address
     */
    private $address;
    /**
     * @var Reminder
     */
    private $reminder;

    public function __construct(
        SamDatabaseSeeder $sam_seeder,
        Organisation $organisation,
        User $user,
        Person $person,
        Employee $employee,
        Advocate $advocate,
        ActivePeriod $active_period,
        ServiceUser $service_user,
        ServiceUserCase $service_user_case,
        ContactEntity $contact_entity,
        Contact $contact,
        Task $task,
        Independent $independent,
        Role $role,
        Address $address,
        Reminder $reminder
    )
    {
        $this->organisation = $organisation;
        $this->user = $user;
        $this->person = $person;
        $this->employee = $employee;
        $this->advocate = $advocate;
        $this->active_period = $active_period;
        $this->service_user = $service_user;
        $this->service_user_case = $service_user_case;
        $this->contact_entity = $contact_entity;
        $this->contact = $contact;
        $this->task = $task;
        $this->independent = $independent;
        $this->role = $role;
        $this->sam_seeder = $sam_seeder;
        $this->address = $address;
        $this->reminder = $reminder;
    }

    protected function truncateAll() {
        $tableNames = Schema::getConnection()->getDoctrineSchemaManager()->listTableNames();
        foreach ($tableNames as $name) {
            //if you don't want to truncate migrations
            if ($name == 'migrations') {
                continue;
            }
            DB::table($name)->truncate();
        }
    }

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        $this->truncateAll();

        $this->sam_seeder->run();

        // Organisation
        $sample_organisation = $this->organisation->create(['name' => 'Huddle Advocacy']);

        // Manager

        $manager_role = $this->role->where('name','=','manager')->first();

        $manager_user = $this->user->create([
            'email' => 'charley.winship@example.com',
            'password' => Hash::make('default-password')
        ]);

        $manager_person = $this->person->create([
            'title' => 'Mr',
            'first_name' => 'Charley',
            'last_name' => 'Winship',
            'gender_id' => 1,
            'organisation_id' => $sample_organisation->id
        ]);

        $manager_contact = $this->contact->create([
            'email' => 'charley.winship@example.com'
        ]);

        $manager_person->contact()->associate($manager_contact)->save();

        $manager_employee = $this->employee->create([
            'person_id' => $manager_person->id,
            'user_id' => $manager_user->id,
            'clean_driving_license' => false,
            'access_to_car' => false
        ]);

        $manager_active_period = $this->active_period->create([
            'start' => '2015-01-01',
            'role_id' => $manager_role->id,
            'activated_by_user_id' => 1
        ]);

        $manager_user->attachRole($manager_role->id);

        $manager_employee->active_periods()->attach($manager_active_period);
        $manager_employee->save();

        // Coordinator

        $coordinator_role = $this->role->where('name','=','coordinator')->first();

        $coordinator_user = $this->user->create([
            'email' => 'tricia.keen@example.com',
            'password' => Hash::make('default-password')
        ]);

        $coordinator_person = $this->person->create([
            'title' => 'Mrs',
            'first_name' => 'Tricia',
            'last_name' => 'Keen',
            'gender_id' => 2,
            'organisation_id' => $sample_organisation->id
        ]);

        $coordinator_contact = $this->contact->create([
            'email' => 'tricia.keen@example.com'
        ]);

        $coordinator_person->contact()->associate($coordinator_contact)->save();

        $coordinator_employee = $this->employee->create([
            'person_id' => $coordinator_person->id,
            'user_id' => $coordinator_user->id,
            'clean_driving_license' => false,
            'access_to_car' => false
        ]);

        $coordinator_active_period = $this->active_period->create([
            'start' => '2015-01-01',
            'role_id' => $coordinator_role->id,
            'activated_by_user_id' => 1
        ]);

        $coordinator_user->attachRole($coordinator_role->id);

        $coordinator_employee->active_periods()->attach($coordinator_active_period);
        $coordinator_employee->save();

        // Observer

        $observer_role = $this->role->where('name','=','observer')->first();

        $observer_user = $this->user->create([
            'email' => 'kaye.foster@example.com',
            'password' => Hash::make('default-password')
        ]);

        $observer_independent = $this->independent->create([
            'name' => 'Kaye Foster',
            'user_id' => $observer_user->id,
            'company' => 'Funding Agency',
            'job_role' => 'External Observer'
        ]);

        $observer_active_period = $this->active_period->create([
            'start' => '2015-01-01',
            'role_id' => $observer_role->id,
            'activated_by_user_id' => 1
        ]);

        $observer_user->attachRole($observer_role->id);

        $observer_independent->active_periods()->attach($observer_active_period);
        $observer_independent->save();

        // Advocate 1

        $advocate_role = $this->role->where('name','=','advocate')->first();

        $advocate_user_1 = $this->user->create([
            'email' => 'eddy.dennell@example.com',
            'password' => Hash::make('default-password')
        ]);

        $advocate_person_1 = $this->person->create([
            'title' => 'Mr',
            'first_name' => 'Eddy',
            'last_name' => 'Dennell',
            'gender_id' => 1,
            'organisation_id' => $sample_organisation->id
        ]);

        $advocate_contact_1 = $this->contact->create([
            'email' => 'eddy.dennell@example.com'
        ]);

        $advocate_person_1->contact()->associate($advocate_contact_1)->save();

        $advocate_employee_1 = $this->employee->create([
            'person_id' => $advocate_person_1->id,
            'user_id' => $advocate_user_1->id,
            'clean_driving_license' => false,
            'access_to_car' => false
        ]);

        $advocate_active_period_1 = $this->active_period->create([
            'start' => '2015-01-01',
            'role_id' => $advocate_role->id,
            'activated_by_user_id' => 1
        ]);

        $advocate_1 = $this->advocate->create([
            'type_of_advocate' => 'Paid',
            'employee_id' => $advocate_employee_1->id
        ]);

        $advocate_user_1->attachRole($advocate_role->id);

        $advocate_employee_1->active_periods()->attach($advocate_active_period_1);
        $advocate_employee_1->save();

        $advocate_previous_employer_contact_1 = $this->contact->create([
            'phone1' => '0161 555 2368'
        ]);

        $advocate_previous_employer_1 = $this->contact_entity->create([
            'name' => 'Dorset Advocacy',
            'is_company' => true,
            'contact_id' => $advocate_previous_employer_contact_1->id
        ]);

        $advocate_person_1->contact_entities()->attach($advocate_previous_employer_1, ['contact_entity_type_id' => 4]);

        $advocate_reference_contact_1 = $this->contact->create([
            'phone1' => '0161 345 5345'
        ]);

        $advocate_reference_1 = $this->contact_entity->create([
            'name' => 'Dorset University',
            'is_company' => true,
            'contact_id' => $advocate_reference_contact_1->id
        ]);

        $advocate_person_1->contact_entities()->attach($advocate_reference_1, ['contact_entity_type_id' => 5]);

        // Advocate 2
        $advocate_user_2 = $this->user->create([
            'email' => 'kylee.kinsley@example.com',
            'password' => Hash::make('default-password')
        ]);

        $advocate_person_2 = $this->person->create([
            'title' => 'Miss',
            'first_name' => 'Kylee',
            'last_name' => 'Kinsley',
            'gender_id' => 2,
            'organisation_id' => $sample_organisation->id
        ]);

        $advocate_contact_2 = $this->contact->create([
            'email' => 'kylee.kinsley@example.com'
        ]);

        $advocate_person_2->contact()->associate($advocate_contact_2)->save();

        $advocate_employee_2 = $this->employee->create([
            'person_id' => $advocate_person_2->id,
            'user_id' => $advocate_user_2->id,
            'clean_driving_license' => false,
            'access_to_car' => false
        ]);

        $advocate_active_period_2 = $this->active_period->create([
            'start' => '2015-01-01',
            'role_id' => $advocate_role->id,
            'activated_by_user_id' => 1
        ]);

        $advocate_2 = $this->advocate->create([
            'type_of_advocate' => 'Volunteer',
            'employee_id' => $advocate_employee_2->id
        ]);

        $advocate_user_2->attachRole($advocate_role->id);

        $advocate_employee_2->active_periods()->attach($advocate_active_period_2);
        $advocate_employee_2->save();

        $advocate_previous_employer_2 = $this->contact_entity->create([
            'name' => 'Cheshire Advocacy',
            'is_company' => true
        ]);

        $advocate_previous_employer_contact_2 = $this->contact->create([
            'phone1' => '0161 924 3454'
        ]);

        $advocate_previous_employer_2_1 = $this->contact_entity->create([
            'name' => 'John Tise',
            'contact_id' => $advocate_previous_employer_contact_2->id,
            'company_id' => $advocate_previous_employer_2->id
        ]);

        $advocate_person_2->contact_entities()->attach($advocate_previous_employer_2_1, ['contact_entity_type_id' => 4]);

        $advocate_reference_contact_2 = $this->contact->create([
            'phone1' => '0161 921 4534'
        ]);

        $advocate_reference_2 = $this->contact_entity->create([
            'name' => 'Cheshire University',
            'is_company' => true,
            'contact_id' => $advocate_reference_contact_2->id
        ]);

        $advocate_person_2->contact_entities()->attach($advocate_reference_2, ['contact_entity_type_id' => 5]);

        // Service User 1
        $service_user_address_1 = $this->address->create([
            'line_1' => '87 Whitworth Street',
            'postal_code' => 'M1'
        ]);

        $service_user_contact_1 = $this->contact->create([
            'phone1' => '0161 321 3534'
        ]);

        $service_user_contact_1->addresses()->attach($service_user_address_1);

        $service_user_person_1 = $this->person->create([
            'title' => 'Ms',
            'first_name' => 'Justine',
            'last_name' => 'Headley',
            'gender_id' => 2,
            'organisation_id' => $sample_organisation->id,
            'contact_id' => $service_user_contact_1->id
        ]);

        $service_user_1 = $this->service_user->create([
            'person_id' => $service_user_person_1->id
        ]);

        $service_user_next_of_kin_contact_1 = $this->contact->create([
            'phone1' => '0161 321 3534'
        ]);

        $service_user_next_of_kin_1 = $this->contact_entity->create([
            'name' => 'Neva Willard',
            'contact_id' => $service_user_next_of_kin_contact_1->id
        ]);

        $service_user_person_1->contact_entities()->attach($service_user_next_of_kin_1, ['contact_entity_type_id' => 2]);

        $advocate_referrer_contact_1 = $this->contact->create([
            'phone1' => '0161 345 5345'
        ]);

        $advocate_referrer_1 = $this->contact_entity->create([
            'name' => 'Ferdy Fairbairn',
            'contact_id' => $advocate_referrer_contact_1->id
        ]);

        $service_user_person_1->contact_entities()->attach($advocate_referrer_1, ['contact_entity_type_id' => 3]);

        // Service User 2
        $service_user_address_2 = $this->address->create([
            'line_1' => '24 Oak Street',
            'postal_code' => 'M29 8AG'
        ]);

        $service_user_contact_2 = $this->contact->create([
            'phone1' => '0161 868 4538'
        ]);

        $service_user_contact_2->addresses()->attach($service_user_address_2);

        $service_user_person_2 = $this->person->create([
            'title' => 'Mr',
            'first_name' => 'Marty',
            'last_name' => 'Proudfoot',
            'gender_id' => 1,
            'organisation_id' => $sample_organisation->id,
            'contact_id' => $service_user_contact_2->id
        ]);

        $service_user_2 = $this->service_user->create([
            'person_id' => $service_user_person_2->id
        ]);

        $service_user_next_of_kin_contact_2 = $this->contact->create([
            'phone1' => '0161 321 3534'
        ]);

        $service_user_next_of_kin_2 = $this->contact_entity->create([
            'name' => 'Karl Eccleston',
            'contact_id' => $service_user_next_of_kin_contact_2->id
        ]);

        $service_user_person_2->contact_entities()->attach($service_user_next_of_kin_2, ['contact_entity_type_id' => 2]);

        $advocate_referrer_contact_2 = $this->contact->create([
            'phone1' => '0161 345 5345'
        ]);

        $advocate_referrer_2 = $this->contact_entity->create([
            'name' => 'Malakai Easom',
            'contact_id' => $advocate_referrer_contact_2->id
        ]);

        $service_user_person_2->contact_entities()->attach($advocate_referrer_2, ['contact_entity_type_id' => 3]);

        // Service User 3
        $service_user_address_3 = $this->address->create([
            'line_1' => '19 Charleston Avenue',
            'postal_code' => 'M33 4US'
        ]);

        $service_user_contact_3 = $this->contact->create([
            'phone1' => '0161 321 3534'
        ]);

        $service_user_contact_3->addresses()->attach($service_user_address_3);

        $service_user_person_3 = $this->person->create([
            'title' => 'Dr',
            'first_name' => 'Jaylen',
            'last_name' => 'Ackerman',
            'gender_id' => 2,
            'organisation_id' => $sample_organisation->id,
            'contact_id' => $service_user_contact_3->id
        ]);

        $service_user_3 = $this->service_user->create([
            'person_id' => $service_user_person_3->id
        ]);

        $service_user_next_of_kin_contact_3 = $this->contact->create([
            'phone1' => '0161 321 3534'
        ]);

        $service_user_next_of_kin_3 = $this->contact_entity->create([
            'name' => 'Sheryll Royce',
            'contact_id' => $service_user_next_of_kin_contact_3->id
        ]);

        $service_user_person_3->contact_entities()->attach($service_user_next_of_kin_3, ['contact_entity_type_id' => 2]);

        $advocate_referrer_contact_3 = $this->contact->create([
            'phone1' => '0161 345 5345'
        ]);

        $advocate_referrer_3 = $this->contact_entity->create([
            'name' => 'Brand Savege',
            'contact_id' => $advocate_referrer_contact_3->id
        ]);

        $service_user_person_3->contact_entities()->attach($advocate_referrer_3, ['contact_entity_type_id' => 3]);

        // Service User 4
        $service_user_address_4 = $this->address->create([
            'line_1' => '42 Lime Road',
            'postal_code' => 'M32'
        ]);

        $service_user_contact_4 = $this->contact->create([
            'phone1' => '0161 321 3534'
        ]);

        $service_user_contact_4->addresses()->attach($service_user_address_4);

        $service_user_person_4 = $this->person->create([
            'title' => 'Mr',
            'first_name' => 'Terry',
            'last_name' => 'Trevis',
            'gender_id' => 1,
            'organisation_id' => $sample_organisation->id,
            'contact_id' => $service_user_contact_4->id
        ]);

        $service_user_4 = $this->service_user->create([
            'person_id' => $service_user_person_4->id
        ]);

        $service_user_next_of_kin_contact_4 = $this->contact->create([
            'phone1' => '0161 321 3534'
        ]);

        $service_user_next_of_kin_4 = $this->contact_entity->create([
            'name' => 'Huey Irving',
            'contact_id' => $service_user_next_of_kin_contact_4->id
        ]);

        $service_user_person_4->contact_entities()->attach($service_user_next_of_kin_4, ['contact_entity_type_id' => 2]);

        $advocate_referrer_contact_4 = $this->contact->create([
            'phone1' => '0161 345 5345'
        ]);

        $advocate_referrer_4 = $this->contact_entity->create([
            'name' => 'Dot Purcell',
            'contact_id' => $advocate_referrer_contact_4->id
        ]);

        $service_user_person_4->contact_entities()->attach($advocate_referrer_4, ['contact_entity_type_id' => 3]);

        // Case 1
        $case_1 = $this->service_user_case->create([
            'service_user_id' => $service_user_1->id
        ]);

        $case_1->cancer_types()->attach(1);

        $case_1->advocates()->attach($advocate_1);

        // Case 2
        $case_2 = $this->service_user_case->create([
            'service_user_id' => $service_user_1->id
        ]);

        $case_2->cancer_types()->attach(7);

        $case_2->advocates()->attach($advocate_2);

        // Case 3
        $case_3 = $this->service_user_case->create([
            'service_user_id' => $service_user_2->id
        ]);

        $case_3->cancer_types()->attach(10);

        $case_3->advocates()->attach($advocate_1);

        // Case 4
        $case_4 = $this->service_user_case->create([
            'service_user_id' => $service_user_3->id
        ]);

        $case_4->cancer_types()->attach(3);

        // Reminders

        $this->reminder->create([
            'title' => 'Call Joseph',
            'type' => 'manual',
            'remindee_user_id' => $advocate_user_1->id,
            'date_time' => \Carbon\Carbon::now()->addDay()
        ]);

        $this->reminder->create([
            'title' => 'Email Sally',
            'type' => 'manual',
            'remindee_user_id' => $advocate_user_1->id,
            'date_time' =>  \Carbon\Carbon::now()->addWeek()
        ]);

        $this->reminder->create([
            'title' => 'Add George to system',
            'type' => 'manual',
            'remindee_user_id' => $advocate_user_2->id,
            'date_time' => \Carbon\Carbon::now()->addDays(4)
        ]);

        // Activities

        $this->task->create([
            'date' => \Carbon\Carbon::now()->subDays(6),
            'nature_id' => 1,
            'duration' => 60,
            'outcome' => 'Seemed to go well, service user felt better and more informed.',
            'service_user_case_id' => $case_1->id,
            'user_id' => $advocate_user_1->id
        ]);

        $this->task->create([
            'date' => \Carbon\Carbon::now()->subDays(12),
            'nature_id' => 3,
            'duration' => 60,
            'outcome' => 'It went very well.',
            'service_user_case_id' => $case_2->id,
            'user_id' => $advocate_user_2->id
        ]);

        $this->task->create([
            'date' => \Carbon\Carbon::now()->subDays(18),
            'nature_id' => 11,
            'duration' => 60,
            'service_user_case_id' => $case_3->id,
            'user_id' => $advocate_user_1->id
        ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

    }

}