<?php namespace Concore\Sam\Http\Controllers\Sculpt;

use Concore\Sam\Models\Person;
use Notification, Redirect, Input, Session;
use Concore\Sculpt\Http\Controllers\SculptModelController;

class ServiceUserController extends SculptModelController {

    public function makeFromPerson(Person $person, $model_type, $person_id) {
        $person = $person->find($person_id);
        if(!$person) {
            Notification::error('No person with this ID');
        } else if($this->sculpt_model_service->model->wherePersonId($person->id)->count() > 0) {
            Notification::error('This person is already a service user.');
        } else {
            $this->sculpt_model_service->createRecord([
                'service-user' => [
                    'person_id' => $person->id
                ]
            ]);
            Notification::success($person->name . ' successfully added as a service user.');
        }
        return Redirect::back();
    }

}