<?php namespace Concore\Sam\Http\ViewComposers;

use Input, Session;
use Concore\Personnel\Models\Organisation;
use Illuminate\Contracts\View\View;

class FilterFormComposer {

    public function __construct(Organisation $organisation) {
        $this->organisation = $organisation;
    }

    public function compose(View $view) {
        $list = ['' => ''];
        foreach($this->organisation->lists('name','id') as $id => $name) {
            $list[$id] = $name;
        }
        $view->with('organisations_list',$list);
        $view_data = $view->getData();
        $view->with('input',Session::get('forms.search.' . $view_data['model']->getSluggedPlural()));
    }

}