<?php namespace Concore\Sam\Http\ViewComposers;

use Concore\Personnel\Models\Gender;
use Concore\Sam\Models\Person;
use Concore\Sam\Models\ReferralMethod;
use Concore\Sam\Models\ReferralSource;
use Carbon\Carbon;
use Concore\Sam\Models\ServiceUserCase;
use Illuminate\Contracts\View\View;

class ServiceUserCaseFilterFormComposer extends PersonFilterFormComposer {

    /**
     * @var Gender
     */
    private $gender;
    /**
     * @var ReferralMethod
     */
    private $referral_method;
    /**
     * @var ReferralSource
     */
    private $referral_source;
    /**
     * @var Person
     */
    private $person;
    /**
     * @var ServiceUserCase
     */
    private $service_user_case;

    public function __construct(Gender $gender, Person $person, ReferralMethod $referral_method, ReferralSource $referral_source, ServiceUserCase $service_user_case) {
        $this->referral_method = $referral_method;
        $this->referral_source = $referral_source;
        $this->service_user_case = $service_user_case;
        parent::__construct($gender, $person);
    }

    public function compose(View $view) {
        parent::compose($view);
        $referral_methods = ['' => ''];
        foreach($this->referral_method->lists('name','id') as $id => $name) {
            $referral_methods[$id] = $name;
        }
        $referral_methods['undefined'] = 'Undefined';
        $referral_methods['other'] = 'Other';
        $referral_sources = ['' => ''];
        foreach($this->referral_source->lists('name','id') as $id => $name) {
            $referral_sources[$id] = $name;
        }
        $referral_sources['undefined'] = 'Undefined';
        $referral_sources['other'] = 'Other';
        $how_they_heards = ['' => ''];
        foreach($this->service_user_case->getHowTheyHeards() as $name) {
            $how_they_heards[$name] = $name;
        }
        $how_they_heards['Other'] = 'Other';
        $how_they_heards['Undefined'] = 'Undefined';
        $view->with(compact('referral_methods','referral_sources','how_they_heards'));
    }

}