<?php
Route::group(array_merge(config('sculpt.outer-route-group'),['namespace' => 'Concore\Sam\Http\Controllers\Sculpt', 'middleware' => ['sculpt_auth','sculpt_parse_input']]), function() {
    Route::group(['middleware' => 'sculpt_model_binder'], function() {
        Route::get('/manage/{model_type}/map', ['as' => 'sam.service-user-cases.map','uses' => 'ServiceUserCaseController@map'])->where('model_type', 'service-user-cases');
        Route::get('/manage/{model_type}/from-person/{person_id}', ['as' => 'sam.service-users.from-person','uses' => 'ServiceUserController@makeFromPerson'])->where('model_type', 'service-users');
    });
});
Route::group(['middleware' => ['sculpt_auth']], function() {
    Route::get('/reports/{key?}', ['as' => 'report', 'uses' => 'Concore\Reports\Http\Controllers\ReportsController@show'])->where('key', '[A-Za-z0-9-]+');
    Route::get('/reports/{key?}/export', ['as' => 'report.export', 'uses' => 'Concore\Reports\Http\Controllers\ReportsController@export'])->where('key', '[A-Za-z0-9-]+');
});