<?php namespace Concore\Sam\Models;

use Concore\Foundation\Models\Interfaces\IdentifiableInterface;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Illuminate\Database\Eloquent\Model;

class CancerChampion extends Model implements IdentifiableInterface {

    use IdentifiableTrait;

    public $guarded = ['id','created_at','updated_at'];

    public $removed_validation_rules = ['employee_id'];

    public function employee() {
        return $this->belongsTo(app('Concore\Personnel\Models\Employee'));
    }

}