<?php namespace Concore\Sam\Models;

use Auth;
use Concore\Personnel\Models\ContactEntity as ParentClass;

class ContactEntity extends ParentClass {

    public function service_user_cases() {
        return $this->morphedByMany(app('Concore\Sam\Models\ServiceUserCase'),'contact_entityables');
    }

    public function scopeForServiceUserCases($query, $service_user_case_ids) {
        return $query->orWhereHas('service_user_cases',function($query) use($service_user_case_ids) {
            $query->whereIn('id',$service_user_case_ids);
        });
    }

    public function scopeInOrganisation($query, $organisation_id) {
        return $query->where(function($query) use($organisation_id) {
            $query->whereHas('people',function($query) use($organisation_id) {
                $query->where('organisation_id','=',$organisation_id);
            });
            $query->orWhereHas('notes',function($query) use($organisation_id) {
                $query->where(function($query) use($organisation_id) {
                    $query->whereHas('people',function($query) use($organisation_id) {
                        $query->where('organisation_id','=',$organisation_id);
                    });
                });
            });
            $query->orWhereHas('service_user_cases',function($query) {
                $query->whereHas('service_user',function($query) {
                    $query->whereHas('person',function($query) {
                        $query->where('organisation_id','=',Auth::user()->getOrganisationId());
                    });
                });
            });
        });
    }

}