<?php namespace Concore\Sam\Reports;

use Concore\Personnel\Models\Role;
use Concore\Sam\Models\Employee;
use DB, Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Reports\Traits\ReportableTrait;
use Concore\Reports\Table;
use Concore\Sam\Reports\Interfaces\SamReportableInterface;
use Concore\Sam\Reports\Traits\SamReportableTrait;
use Concore\Sam\Models\Advocate;
use Concore\Sam\Models\ActivePeriod;

class CancerChampionsReport extends EmployeesReport {
    protected $role_name = 'cancer-champion';
    public function getNameAttribute() {
        return 'Cancer Champions';
    }
    protected function getBaseQuery() {
        return $this->employee->has('cancer_champion');
    }
    protected function getActivePeriodBaseQuery() {
        $query = $this->active_period->whereHas('role',function($role) {
            $role->where('name','=',$this->role_name);
        });
        if (!is_null($this->organisation_id)) {
            $query = $query->whereHas('employee', function($query) {
                $query->inOrganisation($this->organisation_id);
                $query->has('cancer_champion');
            });
        } else {
            $query = $query->has('employee');
        }
        return $query;
    }
}