<?php namespace Concore\Sam\Reports;

use Concore\Personnel\Models\Role;
use Concore\Sam\Models\Employee;
use DB, Carbon\Carbon;
use Concore\Foundation\Models\Traits\IdentifiableTrait;
use Concore\Reports\Traits\ReportableTrait;
use Concore\Reports\Table;
use Concore\Sam\Reports\Interfaces\SamReportableInterface;
use Concore\Sam\Reports\Traits\SamReportableTrait;
use Concore\Sam\Models\Advocate;
use Concore\Sam\Models\ActivePeriod;

class PaidAdvocatesReport extends EmployeesReport {
    protected $role_name = 'advocate';
    public function getNameAttribute() {
        return 'Paid Advocates';
    }
    protected function getBaseUrlArgs() {
        $args = parent::getBaseUrlArgs();
        $args['advocate_type'] = 'Paid';
        return $args;
    }
    protected function getBaseQuery() {
        return $this->employee->whereHas('advocate',function($query) {
            $query->where('type_of_advocate','=','Paid');
        });
    }
    protected function getActivePeriodBaseQuery() {
        $query = $this->active_period->whereHas('role',function($role) {
            $role->where('name','=',$this->role_name);
        });
        $query = $query->whereHas('employee', function($query) {
            if (!is_null($this->organisation_id)) {
                $query->inOrganisation($this->organisation_id);
            }
            $query->whereHas('advocate',function($query) {
                $query->where('type_of_advocate','=','Paid');
            });
        });
        return $query;
    }
}