<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddServiceUserCaseIdToTasksTable extends Migration {

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('tasks',function(Blueprint $table) {
            $table->integer('service_user_case_id')->unsigned()->after('id')->nullable();
            $table->foreign('service_user_case_id')->references('id')->on('service_user_cases')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('tasks',function(Blueprint $table) {
            $table->dropForeign('tasks_service_user_case_id_foreign');
            $table->dropColumn('service_user_case_id');
        });
    }

}
