<div class="audit-log">
    <strong class="logger-name">
        @if (Auth::user()->can('see:identifying-information'))
            {{ $log->logger->name }}
        @else
            {{ $log->logger->getSlugged().' #'.$log->logger->id }}
        @endif
    </strong>
    <span class="type">changed advocate(s) for</span>
    @if ($log->loggee_type || $log->loggee_name)
        <span class="loggee">
            @if ($log->loggee_type && $log->loggee_name)
                -
            @endif
            @if ($log->loggee)
                <a href="{{ route("sculpt.show",[$log->loggee->getSluggedPlural(),$log->loggee_id]) }}">
                    @if (!Auth::user()->can('see:identifying-information'))
                        {{ $log->loggee_type_human_readable }}
                    @endif
                    {{ $log->loggee->name }}
                </a>
                @if (Auth::user()->can('see:identifying-information') && $log->loggee_name != $log->loggee->name)
                    ({{ $log->loggee_name }} at the time)
                @endif
            @else
                @if (Auth::user()->can('see:identifying-information'))
                    {{ $log->loggee_name }}
                @else
                    {{ $log->loggee_type_human_readable.' #'.$loggee_id }}
                @endif
            @endif
    </span>
    @endif
    -
    <span class="log-date">on {{ $log->created_at->format('jS F Y g:i:s') }}</span>
    <div class="data">
        @if (isset($log->data['added']) && $log->data['added'])
            Added:
            {{ implode(', ', $log->data['added']) }}
            @if (isset($log->data['removed']) && !empty($log->data['removed']))
                -
            @endif
        @endif
        @if (isset($log->data['removed']) && $log->data['removed'])
            Removed:
            {{ implode(', ', $log->data['removed']) }}
        @endif
    </div>
</div>