@extends('reports::partials.tab-content')

@section('report-tab-panel')
    <?php $tables = $report->getTables(); ?>
    <h3>{{ $tables['activities_totals_table']->getTitle() }}</h3>
    @include('reports::partials.table',['table' => $tables['activities_totals_table']])
    <p>The figures below correspond to the new advocates activated and existing advocates reactivated during this period (the rows in bold above).</p>
    <h3>{{ $tables['individual_activity_totals_table']->getTitle() }}</h3>
    @include('reports::partials.table',['table' => $tables['individual_activity_totals_table']])
    <h3>
        {{ $tables['timeslot_totals_table']->getTitle() }}
    </h3>
    @include('reports::partials.table',['table' => $tables['timeslot_totals_table']])
    <small>
        <p class="text-muted"><strong>Activities by what they involved example:</strong> For Letter writing, the figures are as follows:</p>
        <ul class="text-muted">
            <li><strong>Number of activities</strong> - how many activities involved letter writing</li>
            <li><strong>Total activity duration</strong> - total amount of these activities as a whole (including time spent on other things like emails, travel)</li>
            <li><strong>Average activity duration</strong> - average amount of these activities as a whole</li>
            <li><Strong>Total timeslot duration</Strong> - total amount of time actually spent letter writing across these activities</li>
            <li><strong>Average timeslot duration</strong> - average amount of time actually spent letter writing across these activities</li>
            <li><strong>Affected cases</strong> - how many cases these activities are spread across</li>
        </ul>
    </small>
@stop

@section('head-after-style')
    @parent
    <style>
        #totals                             tr td:last-child {
            width: 200px;
        }
        #activities-by-nature               tr td:nth-last-child(-n + 4),
        #activities-by-what-they-involved   tr td:nth-last-child(-n + 4) {
            width:100px;
        }
    </style>
@stop
