@extends('reports::partials.tab-content')

{{-- Not actually used directly, but extended by paid-advocates-report and volunteer-advocates-report --}}

@section('report-tab-panel')
    <?php $tables = $report->getTables(); ?>
    <div class="row">
        <div class="col-sm-4">
            <h5>{{ $tables['start_of_period_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['start_of_period_table']])
        </div>
        <div class="col-sm-4">
            <h5>{{ $tables['during_period_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['during_period_table']])
        </div>
        <div class="col-sm-4">
            <h5>
                {{ $tables['end_of_period_table']->getTitle() }}
                <span data-toggle="popover" data-trigger="hover" data-content="<ol class='sum'>
        <li><span>{{ $tables['start_of_period_table']->getRows()[0][1] }}</span> active at start</li>
        <li><i class='fa fa-plus'></i> <span>{{ $tables['during_period_table']->getRows()[0][1] }}</span> activations</li>
        <li><i class='fa fa-plus'></i> <span>{{ $tables['during_period_table']->getRows()[1][1] }}</span> reactivations</li>
        <li><i class='fa fa-minus'></i> <span>{{ $tables['during_period_table']->getRows()[2][1] }}</span> deactivations</li>
        <li class='total'><span>{{ $tables['start_of_period_table']->getRows()[0][1] +
           $tables['during_period_table']->getRows()[0][1] +
           $tables['during_period_table']->getRows()[1][1] -
           $tables['during_period_table']->getRows()[2][1] }}</span> active at end</li>
    </ol>
    <ol class='sum'>
        <li><span>{{ $tables['start_of_period_table']->getRows()[1][1] }}</span> yet to be activated at start</li>
        <li><i class='fa fa-minus'></i> <span>{{ $tables['during_period_table']->getRows()[0][1] }}</span> activations</li>
        <li class='total'><span>{{ $tables['start_of_period_table']->getRows()[1][1] -
           $tables['during_period_table']->getRows()[0][1] }}</span> yet to be activated at end</li>
    </ol>
    <ol class='sum'>
        <li><span>{{ $tables['start_of_period_table']->getRows()[2][1] }}</span> inactive at start</li>
        <li><i class='fa fa-plus'></i> <span>{{ $tables['during_period_table']->getRows()[2][1] }}</span> deactivations</li>
        <li><i class='fa fa-minus'></i> <span>{{ $tables['during_period_table']->getRows()[1][1] }}</span> reactivations</li>
        <li class='total'><span>{{ $tables['start_of_period_table']->getRows()[2][1] +
           $tables['during_period_table']->getRows()[2][1] -
           $tables['during_period_table']->getRows()[1][1] }}</span> inactive at end</li>
    </ol>" class="text-muted">
                    <i class="fa fa-fw fa-info-circle"></i>
                </span>
            </h5>
            @include('reports::partials.table',['table' => $tables['end_of_period_table']])
        </div>
    </div>
    <p class="alert alert-info">All figures below correspond to the people which were activated and/or reactivated during this period (the people corresponding to the rows in bold above).</p>
    <div class="row">
        <div class="col-sm-7">
            <h3>{{ $tables['gender_totals_table']->getTitle() }}</h3>
            @include('reports::partials.table',['table' => $tables['gender_totals_table']])
            <h3>{{ $tables['ethnicity_totals_table']->getTitle() }}</h3>
            @include('reports::partials.table',['table' => $tables['ethnicity_totals_table']])
        </div>
        <div class="col-sm-5">
            <h3>{{ $tables['age_totals_table']->getTitle() }}</h3>
            @include('reports::partials.table',['table' => $tables['age_totals_table']])
        </div>
    </div>
@stop

@section('head-after-style')
    @parent
    <style>
        #start-of-period                    tr td:last-child,
        #during-period                      tr td:last-child,
        #end-of-period                      tr td:last-child {
            width: 50px;
        }
        #during-period tbody tr:nth-of-type(1) td,
        #during-period tbody tr:nth-of-type(2) td {
            font-weight:bold;
        }
        #gender                             tr td:last-child,
        #ethnicity                          tr td:last-child,
        #age                                tr td:last-child {
            width: 100px;
        }
    </style>
@stop
