@extends('reports::partials.tab-content')

@section('report-tab-panel')
    <?php $tables = $report->getTables(); ?>
    <div class="row">
        <div class="col-sm-4">
            <h5>{{ $tables['start_of_period_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['start_of_period_table']])
        </div>
        <div class="col-sm-4">
            <h5>{{ $tables['during_period_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['during_period_table']])
        </div>
        <div class="col-sm-4">
            <h5>
                {{ $tables['end_of_period_table']->getTitle() }}
                <span data-toggle="popover" data-trigger="hover" data-content="<ol class='sum'>
        <li><span>{{ $tables['start_of_period_table']->getRows()[0][1] }}</span> open cases at start</li>
        <li><i class='fa fa-plus'></i> <span>{{ $tables['during_period_table']->getRows()[0][1] }}</span> openings</li>
        <li><i class='fa fa-plus'></i> <span>{{ $tables['during_period_table']->getRows()[1][1] }}</span> reopenings</li>
        <li><i class='fa fa-minus'></i> <span>{{ $tables['during_period_table']->getRows()[2][1] }}</span> closings</li>
        <li class='total'><span>{{ $tables['start_of_period_table']->getRows()[0][1] +
           $tables['during_period_table']->getRows()[0][1] +
           $tables['during_period_table']->getRows()[1][1] -
           $tables['during_period_table']->getRows()[2][1] }}</span> open at end</li>
    </ol>
    <ol class='sum'>
        <li><span>{{ $tables['start_of_period_table']->getRows()[1][1] }}</span> yet to be opened at start</li>
        <li><i class='fa fa-minus'></i> <span>{{ $tables['during_period_table']->getRows()[0][1] }}</span> openings</li>
        <li class='total'><span>{{ $tables['start_of_period_table']->getRows()[1][1] -
           $tables['during_period_table']->getRows()[0][1] }}</span> yet to be opened at end</li>
    </ol>
    <ol class='sum'>
        <li><span>{{ $tables['start_of_period_table']->getRows()[2][1] }}</span> closed at start</li>
        <li><i class='fa fa-plus'></i> <span>{{ $tables['during_period_table']->getRows()[2][1] }}</span> closings</li>
        <li><i class='fa fa-minus'></i> <span>{{ $tables['during_period_table']->getRows()[1][1] }}</span> reopenings</li>
        <li class='total'><span>{{ $tables['start_of_period_table']->getRows()[2][1] +
           $tables['during_period_table']->getRows()[2][1] -
           $tables['during_period_table']->getRows()[1][1] }}</span> closed at end</li>
    </ol>" class="text-muted">
                    <i class="fa fa-fw fa-info-circle"></i>
                </span>
            </h5>
            @include('reports::partials.table',['table' => $tables['end_of_period_table']])
        </div>
    </div>

    @include('reports::partials.table',['table' => $tables['activities_table']])
    <p class="alert alert-info">All figures below correspond to the cases which were opened and/or reopened during this period (the cases corresponding to the rows in bold above).</p>
    <h3>{{ $tables['case_types_table']->getTitle() }}</h3>
    @include('reports::partials.table',['table' => $tables['case_types_table']])
    <h3>Referrals</h3>
    <div class="row">
        <div class="col-sm-7">
            <h5>{{ $tables['referral_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['referral_totals_table']])
        </div>
        <div class="col-sm-5">
            <h5>{{ $tables['referral_methods_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['referral_methods_totals_table']])
            <h5>{{ $tables['how_they_heard_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['how_they_heard_totals_table']])
        </div>
    </div>
    <h3>Case Info</h3>
    <div class="row">
        <div class="col-sm-6">
            <h5>{{ $tables['cancer_type_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['cancer_type_totals_table']])
        </div>
        <div class="col-sm-6">
            <h5>{{ $tables['journey_stage_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['journey_stage_totals_table']])
            <h5>{{ $tables['advocacy_issue_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['advocacy_issue_totals_table']])
        </div>
    </div>
    <h3>Demographics</h3>
    <div class="row">
        <div class="col-sm-7">
            <h5>{{ $tables['gender_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['gender_totals_table']])
            <h5>{{ $tables['ethnicity_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['ethnicity_totals_table']])
        </div>
        <div class="col-sm-5">
            <h5>{{ $tables['age_totals_table']->getTitle() }}</h5>
            @include('reports::partials.table',['table' => $tables['age_totals_table']])
        </div>
    </div>
@stop

@section('head-after-style')
    @parent
    <style>
        #start-of-period                    tr td:last-child,
        #during-period                      tr td:last-child,
        #end-of-period                      tr td:last-child {
            width: 50px;
        }
        #during-period tbody tr:nth-of-type(1) td,
        #during-period tbody tr:nth-of-type(2) td {
            font-weight:bold;
        }
        #case-type                          tr td:last-child,
        #referral-source                    tr td:last-child,
        #referral-method                    tr td:last-child,
        #gender                             tr td:last-child,
        #ethnicity                          tr td:last-child,
        #age                                tr td:last-child,
        #activities                         tr td:last-child {
            width: 100px;
        }
    </style>
@stop
