<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">Who and When</h3>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-sm-4">
                @include(Sculpt::getView('partials.forms.relation'),['relation' => 'service_user_case'])
            </div>
            <div class="col-sm-3">
                @if (Auth::user()->can('do:change-activity-creator'))
                    @include(Sculpt::getView('partials.forms.relation'),['relation' => 'user'])
                @elseif(!$record->id)
                    <label class="control-label">Undertaken by:</label>
                    <div class="form-control-static">{{ Auth::user()->name }}</div>
                    {!! Form::hidden('activity[user_id]',Auth::user()->id) !!}
                @endif
            </div>
            <div class="col-sm-5">
                @include(Sculpt::getView('partials.forms.field'),['field' => 'date'])
            </div>
        </div>
        @include(Sculpt::getView('partials.forms.relation'),['relation' => 'people_present'])
        @include(Sculpt::getView('partials.forms.field'),['field' => 'people_present_other'])
    </div>
</div>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title">Describe this activity</h3>
    </div>
    <div class="panel-body">
        <div class="form-group">
            <label for="activity[nature_id]" class="control-label">
                Nature of activity
            </label>
            @if($record->nature_id && $nature_visibility[$record->nature_id] !== ($record->service_user_case_id ? 'case' : 'advocate'))
                <div class="alert alert-warning">
                    <h5><i class="fa fa-fw fa-exclamation-triangle"></i> Warning</h5>
                    <p>
                        This activity was created using an old version of SAM, where the nature of the activity was not restricted. In this version of SAM, the activity nature chosen - <strong>{{ $record->nature->name }}</strong> - is not allowed when the activity is not assigned to a case. In order to save this activity, a different nature needs to be chosen from the list below and/or it will need to be associated with a case.
                    </p>
                </div>
            @endif
            <select name="activity[nature_id]" class="form-control" data-other-field-name="activity[nature_other]" data-hide-disabled="true">
                @foreach($natures as $id => $nature)
                    @if(is_array($nature))
                        <optgroup label="{{ $id }}">
                            @foreach($nature as $_id => $_nature)
                                <option value="{{ $_id }}"{!! $record->nature_id === $_id || Input::old('activity.nature_id') == $_id ? " selected='selected'" : "" !!} class="{{ $nature_classes[$_id] }}">{{ $_nature }}</option>
                            @endforeach
                        </optgroup>
                    @else
                        <option value="{{ $id }}"{!! $record->nature_id === $id ? " selected='selected'" : "" !!} class="{{ isset($nature_visibility[$id]) ? $nature_visibility[$id] : null }}">{{ $nature }}</option>
                    @endif
                @endforeach
            </select>
        </div>
        @include(Sculpt::getView('partials.forms.field'),['field' => 'nature_other'])
        <div class="timeslots">
            @include(Sculpt::getView('partials.forms.relation'),['relation' => 'timeslots'])
        </div>
        @if (Auth::user()->can('see:identifying-information'))
            @include(Sculpt::getView('partials.forms.field'),['field' => 'outcome'])
        @endif
    </div>
</div>

@include(Sculpt::getView('partials.forms.relation'),['relation' => 'next_activity'])

@section('tabs')
    @parent
    @if (Auth::user()->can('see:identifying-information'))
        <div class="tab" data-tab-title="Other Info">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Other Info</h3>
                </div>
                <div class="panel-body">
                    @include(Sculpt::getView('partials.forms.field'),['field' => 'review_previous'])
                    @include(Sculpt::getView('partials.forms.field'),['field' => 'planned_action'])
                    @include(Sculpt::getView('partials.forms.field'),['field' => 'notes'])
                </div>
            </div>
        </div>
    @endif
@stop

@section('body-end')
    @parent
    <script>
        var $people_present_options = $("select[name='people-present[]'] > option");
        var $user_select = $("select[name='activity[user_id]']");
        var $su_select = $("select[name='activity[service_user_case_id]']");
        var $nature_select = $("select[name='activity[nature_id]']");
        var $timeslot_template = $('#new-relation-template-timeslots');

        // These are provided by view composer to map su case id and user id to their corresponding person id
        var person_id_by_su_case_id = {!! json_encode($person_id_by_su_case_id) !!};
        var person_id_by_user_id = {!! json_encode($person_id_by_user_id) !!};
        var cases_first_advocate_user_id = {!! json_encode($cases_first_advocate_user_id) !!};

        // First, if SU case dropdown has been prefilled with a value,
        // prefill the advocate dropdown with the case's first advocate
        function autoSelectAdvocate() {
            if(typeof cases_first_advocate_user_id[$su_select.val()] !== 'undefined') {
                $user_select.val(cases_first_advocate_user_id[$su_select.val()]).trigger("chosen:updated");
            }
        }
        var previously_chosen = [];
        var disabled = [];

        function checkSelectForPeoplePresent($select, map) {
            var name = $select.attr('name');
            if(typeof disabled[name] === 'undefined') {
                var mapped_id = map[$select.children('option:selected').val()];
                var previously_chosen_choice = previously_chosen[name];
                // This if checks to see whether the previously chosen person had been automatically added but is no longer there (i.e. removed by user).
                // If so it doesn't add the new choice.
                var previously_chosen_then_removed = previously_chosen_choice && !$people_present_options.filter('[value=' + previously_chosen_choice + ']:selected').length;
                if(previously_chosen_then_removed) {
                    disabled[name] = true;
                } else {
                    // If one was chosen previously deselect it now
                    if(previously_chosen_choice) {
                        $people_present_options.filter('[value=' + previously_chosen_choice + ']').removeAttr('selected');
                    }
                    // Select new one and mark as previously selected
                    $people_present_options.filter('[value=' + mapped_id + ']').attr('selected','selected');
                    previously_chosen[name] = mapped_id;
                    $people_present_options.parent().trigger('chosen:updated');
                }
            }
        }

        var $timeslot_template_html = $($timeslot_template.val());

        function checkNaturesAndTimeslots() {
            var $timeslot_selects = $("select[name*='[timeslot][type]']");
            if($su_select.val() === '') {
                $nature_select.find('.advocate').removeAttr('disabled');
                $nature_select.find('.case').attr('disabled','disabled');
                $timeslot_selects.find('.advocate').removeAttr('disabled');
                $timeslot_selects.find('.case').attr('disabled','disabled');
                $timeslot_template_html.find("select[name*='[timeslot][type]']").find('.advocate').removeAttr('disabled');
                $timeslot_template_html.find("select[name*='[timeslot][type]']").find('.case').attr('disabled','disabled');
            } else {
                $nature_select.find('.case').removeAttr('disabled');
                $nature_select.find('.advocate').attr('disabled','disabled');
                $timeslot_selects.find('.case').removeAttr('disabled');
                $timeslot_selects.find('.advocate').attr('disabled','disabled');
                $timeslot_template_html.find("select[name*='[timeslot][type]']").find('.advocate').attr('disabled','disabled');
                $timeslot_template_html.find("select[name*='[timeslot][type]']").find('.case').removeAttr('disabled');
            }
            $nature_select.add($timeslot_selects).each(function() {
                if($(this).find('option:selected').prop('disabled')) {
                    $(this).val('');
                }
            });
            $timeslot_template.val($timeslot_template_html[0].outerHTML);
            $nature_select.trigger("chosen:updated");
            $timeslot_selects.trigger("chosen:updated");
        }

        @if(!$record->id && count(Input::old()) === 0)
            {{-- Only do all this automation if it's a new activity, without existing input (i.e. user hasn't submitted form and got validation errors) --}}
            autoSelectAdvocate();
            checkSelectForPeoplePresent($su_select, person_id_by_su_case_id);
            checkSelectForPeoplePresent($user_select, person_id_by_user_id);
            checkNaturesAndTimeslots();
            $user_select.change(function() {
                checkSelectForPeoplePresent($user_select, person_id_by_user_id);
            });
            $su_select.change(function() {
                autoSelectAdvocate();
                checkNaturesAndTimeslots();
                checkSelectForPeoplePresent($su_select, person_id_by_su_case_id);
                checkSelectForPeoplePresent($user_select, person_id_by_user_id);
            });
        @endif

    </script>
@stop